<?php
/**
 * Copyright 2013 Adobe
 * All Rights Reserved.
 */

/**
 * CatalogRule data helper
 */
namespace Magento\CatalogRule\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Algorithm for calculating price by rule
     *
     * @param  string $actionOperator
     * @param  int $ruleAmount
     * @param  float $price
     * @return float|int
     */
    public function calcPriceRule($actionOperator, $ruleAmount, $price)
    {
        $priceRule = 0;
        switch ($actionOperator) {
            case 'to_fixed':
                $priceRule = min($ruleAmount, $price);
                break;
            case 'to_percent':
                $priceRule = $price * $ruleAmount / 100;
                break;
            case 'by_fixed':
                $priceRule = max(0, $price - $ruleAmount);
                break;
            case 'by_percent':
                $priceRule = $price * (1 - $ruleAmount / 100);
                break;
        }
        return $priceRule;
    }
}
