<?php
/**
 * Copyright 2023 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\CustomerGraphQl\Model\Resolver;

use Magento\Framework\Api\CustomAttributesDataInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Resolver Custom Attribute filter
 */
class CustomAttributeFilter implements ResolverInterface
{
    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        ?array $value = null,
        ?array $args = null
    ): array {
        $customAttributes = $value[CustomAttributesDataInterface::CUSTOM_ATTRIBUTES];
        if (!empty($args['attributeCodes'])) {
            $attributeCodes = array_values($args['attributeCodes']);
            return array_filter($customAttributes, function ($attr) use ($attributeCodes) {
                return in_array($attr['code'], $attributeCodes);
            });
        }

        return $customAttributes;
    }
}
