<?php declare(strict_types=1);
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
namespace Magento\Developer\Test\Unit\Model\Config\Source;

use Magento\Developer\Model\Config\Source\WorkflowType;
use Magento\Framework\Option\ArrayInterface;
use Magento\Framework\Phrase;
use PHPUnit\Framework\TestCase;

class WorkflowTypeTest extends TestCase
{
    /**
     * @var WorkflowType
     */
    protected $model;

    protected function setUp(): void
    {
        $this->model = new WorkflowType();
    }

    public function testToOptionArray()
    {
        $this->assertInstanceOf(ArrayInterface::class, $this->model);
        $this->assertCount(2, $this->model->toOptionArray());
        $option = current($this->model->toOptionArray());

        /** @var Phrase $label */
        $label = $option['label'];
        $this->assertInstanceOf(Phrase::class, $label);
    }

    public function testOptionStructure()
    {
        foreach ($this->model->toOptionArray() as $option) {
            $this->assertArrayHasKey('value', $option);
            $this->assertArrayHasKey('label', $option);
        }
    }
}
