<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
namespace Magento\InstantPurchase\Model\QuoteManagement;

use Magento\Framework\Exception\LocalizedException;
use Magento\Quote\Api\CartManagementInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\Quote;

/**
 * Purchase products from quote.
 *
 * @api May be used for pluginization.
 * @since 100.2.0
 */
class Purchase
{
    /**
     * @var CartRepositoryInterface
     */
    private $quoteRepository;

    /**
     * @var CartManagementInterface
     */
    private $quoteManagement;

    /**
     * Purchase constructor.
     * @param CartRepositoryInterface $quoteRepository
     * @param CartManagementInterface $quoteManagement
     */
    public function __construct(
        CartRepositoryInterface $quoteRepository,
        CartManagementInterface $quoteManagement
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->quoteManagement = $quoteManagement;
    }

    /**
     * Summarize quote and place order.
     *
     * @param Quote $quote
     * @return int Order id
     * @throws LocalizedException if order can not be placed for a quote.
     * @since 100.2.0
     */
    public function purchase(Quote $quote): int
    {
        $quote->collectTotals();
        $this->quoteRepository->save($quote);
        $orderId = $this->quoteManagement->placeOrder($quote->getId());
        return $orderId;
    }
}
