<?php
/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\InventoryCatalogApi\Api;

/**
 * Perform bulk product source un-assignment
 *
 * @api
 */
interface BulkSourceUnassignInterface
{
    /**
     * Run mass product to source un-assignment
     *
     * @param string[] $skus
     * @param string[] $sourceCodes
     * @return int
     * @throws \Magento\Framework\Validation\ValidationException
     */
    public function execute(array $skus, array $sourceCodes): int;
}
