<?php
/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

use Magento\CatalogInventory\Model\Stock;
use Magento\Framework\Api\DataObjectHelper;
use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;
use Magento\InventoryCatalog\Model\ResourceModel\SetDataToLegacyStockItem;
use Magento\InventoryCatalog\Model\ResourceModel\SetDataToLegacyStockStatus;
use Magento\InventoryCatalogApi\Api\DefaultSourceProviderInterface;
use Magento\InventorySalesApi\Api\AreProductsSalableInterface;
use Magento\TestFramework\Helper\Bootstrap;

/** @var DataObjectHelper $dataObjectHelper */
$dataObjectHelper = Bootstrap::getObjectManager()->get(DataObjectHelper::class);
/** @var SourceItemInterfaceFactory $sourceItemFactory */
$sourceItemFactory = Bootstrap::getObjectManager()->get(SourceItemInterfaceFactory::class);
/** @var  SourceItemsSaveInterface $sourceItemsSave */
$sourceItemsSave = Bootstrap::getObjectManager()->get(SourceItemsSaveInterface::class);
/** @var DefaultSourceProviderInterface $defaultSourceProvider */
$defaultSourceProvider = Bootstrap::getObjectManager()->get(DefaultSourceProviderInterface::class);

/**
 * | *Sku*  | *Source Code* | *Qty* | *Info*        |
 * |--------|---------------|-------|---------------|
 * | VIRT-1 | default       | 33    |               |
 * | VIRT-2 | default       | 30    |               |
 * | VIRT-3 | default       | 2     |               |
 * | VIRT-4 | default       | 6     | out of stock  |
 */
$sourcesItemsData = [
    [
        SourceItemInterface::SOURCE_CODE => $defaultSourceProvider->getCode(),
        SourceItemInterface::SKU => 'VIRT-1',
        SourceItemInterface::QUANTITY => 33,
        SourceItemInterface::STATUS => SourceItemInterface::STATUS_IN_STOCK,
    ],
    [
        SourceItemInterface::SOURCE_CODE => $defaultSourceProvider->getCode(),
        SourceItemInterface::SKU => 'VIRT-2',
        SourceItemInterface::QUANTITY => 30,
        SourceItemInterface::STATUS => SourceItemInterface::STATUS_IN_STOCK,
    ],
    [
        SourceItemInterface::SOURCE_CODE => $defaultSourceProvider->getCode(),
        SourceItemInterface::SKU => 'VIRT-3',
        SourceItemInterface::QUANTITY => 2,
        SourceItemInterface::STATUS => SourceItemInterface::STATUS_IN_STOCK,
    ],
    [
        SourceItemInterface::SOURCE_CODE => $defaultSourceProvider->getCode(),
        SourceItemInterface::SKU => 'VIRT-4',
        SourceItemInterface::QUANTITY => 6,
        SourceItemInterface::STATUS => SourceItemInterface::STATUS_OUT_OF_STOCK,
    ],
];

$sourceItems = [];
$skus = [];
foreach ($sourcesItemsData as $sourceItemData) {
    /** @var SourceItemInterface $source */
    $sourceItem = $sourceItemFactory->create();
    $dataObjectHelper->populateWithArray($sourceItem, $sourceItemData, SourceItemInterface::class);
    $sourceItems[] = $sourceItem;
    $skus[] = $sourceItemData[SourceItemInterface::SKU];
}
$sourceItemsSave->execute($sourceItems);

/** @var AreProductsSalableInterface $areProductsSalable */
$areProductsSalable = Bootstrap::getObjectManager()->get(AreProductsSalableInterface::class);
/** @var SetDataToLegacyStockStatus $setDataToLegacyStockStatus */
$setDataToLegacyStockStatus = Bootstrap::getObjectManager()->get(SetDataToLegacyStockStatus::class);
/** @var SetDataToLegacyStockItem $setDataToLegacyStockItem */
$setDataToLegacyStockItem = Bootstrap::getObjectManager()->get(SetDataToLegacyStockItem::class);

$stockStatuses = [];
foreach ($areProductsSalable->execute($skus, Stock::DEFAULT_STOCK_ID) as $productSalable) {
    $stockStatuses[$productSalable->getSku()] = $productSalable->isSalable();
}
foreach ($sourceItems as $sourceItem) {
    $setDataToLegacyStockItem->execute(
        (string)$sourceItem->getSku(),
        (float)$sourceItem->getQuantity(),
        (int)$sourceItem->getStatus()
    );
    $setDataToLegacyStockStatus->execute(
        (string)$sourceItem->getSku(),
        (float)$sourceItem->getQuantity(),
        $stockStatuses[(string)$sourceItem->getSku()] === true ? 1 : 0
    );
}
