<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\MediaGallerySynchronizationApi\Api;

use Magento\Framework\Exception\LocalizedException;

/**
 * Synchronize assets from the provided files information to database
 * @api
 */
interface SynchronizeFilesInterface
{
    /**
     * Create media gallery assets based on files information and save them to database
     *
     * @param string[] $paths
     * @throws LocalizedException
     */
    public function execute(array $paths): void;
}
