/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 */

import BaseMaster from "../master";

export default class Master extends BaseMaster {

    public isHosted(src: string): boolean {
        const youtubeRegExp = new RegExp("^(?:https?:\/\/|\/\/)?(?:www\\.|m\\.)?" +
            "(?:youtu\\.be\/|(?:youtube\\.com\/|youtube-nocookie\\.com\/)(?:embed\/|v\/|watch\\?v=|watch\\?.+&v=))" +
            "([\\w-]{11})(?![\\w-])");
        const vimeoRegExp = new RegExp("https?:\/\/(?:www\\.|player\\.)?vimeo.com\/(?:channels\/" +
            "(?:\\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\\d+)\/video\/|video\/|)(\\d+)(?:$|\/|\\?)");
        return (vimeoRegExp.test(src) || youtubeRegExp.test(src));
    }

}
