/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */

/* @api */
define([
    'jquery',
    'Magento_Payment/js/view/payment/cc-form',
    'Magento_Ui/js/model/messageList',
    'mage/translate',
    'Magento_Checkout/js/model/full-screen-loader',
    'Magento_Checkout/js/action/set-payment-information',
    'Magento_Checkout/js/model/payment/additional-validators',
    'Magento_Ui/js/modal/alert'
], function (
    $,
    Component,
    messageList,
    $t,
    fullScreenLoader,
    setPaymentInformationAction,
    additionalValidators,
    alert
) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Payment/payment/iframe',
            timeoutId: null,
            timeoutMessage: 'Sorry, but something went wrong.'
        },

        /**
         * @returns {String}
         */
        getSource: function () {
            return window.checkoutConfig.payment.iframe.source[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getControllerName: function () {
            return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getPlaceOrderUrl: function () {
            return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getCgiUrl: function () {
            return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getSaveOrderUrl: function () {
            return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getDateDelim: function () {
            return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getCardFieldsMap: function () {
            return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getExpireYearLength: function () {
            return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];
        },

        /**
         * @param {Object} parent
         * @returns {Function}
         */
        originalPlaceOrder: function (parent) {
            return parent.placeOrder.bind(parent);
        },

        /**
         * @returns {Number}
         */
        getTimeoutTime: function () {
            return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];
        },

        /**
         * @returns {String}
         */
        getTimeoutMessage: function () {
            return $t(this.timeoutMessage);
        },

        /**
         * @override
         */
        placeOrder: function () {
            var self = this;

            if (this.validateHandler() &&
                additionalValidators.validate() &&
                this.isPlaceOrderActionAllowed() === true
            ) {
                fullScreenLoader.startLoader();

                this.isPlaceOrderActionAllowed(false);

                $.when(
                    this.setPaymentInformation()
                ).done(
                    this.done.bind(this)
                ).fail(
                    this.fail.bind(this)
                ).always(
                    function () {
                        self.isPlaceOrderActionAllowed(true);
                    }
                );

                this.initTimeoutHandler();
            }
        },

        /**
         * {Function}
         */
        setPaymentInformation: function () {
            return setPaymentInformationAction(
                this.messageContainer,
                {
                    method: this.getCode()
                }
            );
        },

        /**
         * {Function}
         */
        initTimeoutHandler: function () {
            this.timeoutId = setTimeout(
                this.timeoutHandler.bind(this),
                this.getTimeoutTime()
            );

            $(window).off('clearTimeout')
                .on('clearTimeout', this.clearTimeout.bind(this));
        },

        /**
         * {Function}
         */
        clearTimeout: function () {
            clearTimeout(this.timeoutId);
            this.fail();

            return this;
        },

        /**
         * {Function}
         */
        timeoutHandler: function () {
            this.clearTimeout();

            alert(
                {
                    content: this.getTimeoutMessage(),
                    actions: {

                        /**
                         * {Function}
                         */
                        always: this.alertActionHandler.bind(this)
                    }
                }
            );

            this.fail();
        },

        /**
         * {Function}
         */
        alertActionHandler: function () {
            fullScreenLoader.startLoader();
            window.location.reload();
        },

        /**
         * {Function}
         */
        fail: function () {
            fullScreenLoader.stopLoader();

            return this;
        },

        /**
         * {Function}
         */
        done: function () {
            this.placeOrderHandler().fail(function () {
                fullScreenLoader.stopLoader();
            });

            return this;
        }
    });
});
