<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
namespace Magento\Theme\Api;

use Magento\Theme\Api\Data\DesignConfigInterface;

/**
 * Design config CRUD interface.
 * @api
 * @since 100.1.0
 */
interface DesignConfigRepositoryInterface
{
    /**
     * Get design settings by scope
     *
     * @param string $scope
     * @param mixed $scopeId
     * @return DesignConfigInterface
     * @since 100.1.0
     */
    public function getByScope($scope, $scopeId);

    /**
     * Save design settings
     *
     * @param DesignConfigInterface $designConfig
     * @return DesignConfigInterface
     * @since 100.1.0
     */
    public function save(DesignConfigInterface $designConfig);

    /**
     * Delete design settings
     *
     * @param DesignConfigInterface $designConfig
     * @return DesignConfigInterface
     * @since 100.1.0
     */
    public function delete(DesignConfigInterface $designConfig);
}
