<?php
/**
 * Copyright 2023 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\UrlRewrite\Test\Fixture;

use Magento\Framework\DataObject;
use Magento\TestFramework\Fixture\Data\ProcessorInterface;
use Magento\TestFramework\Fixture\RevertibleDataFixtureInterface;
use Magento\UrlRewrite\Model\ResourceModel\UrlRewrite as UrlRewriteResourceModel;
use Magento\UrlRewrite\Model\UrlRewriteFactory;
use Magento\UrlRewrite\Service\V1\Data\UrlRewrite as UrlRewriteDataModel;

class UrlRewrite implements RevertibleDataFixtureInterface
{
    private const DEFAULT_DATA = [
        UrlRewriteDataModel::URL_REWRITE_ID => null,
        UrlRewriteDataModel::ENTITY_ID => 0,
        UrlRewriteDataModel::ENTITY_TYPE => 'custom',
        UrlRewriteDataModel::IS_AUTOGENERATED => 0,
        UrlRewriteDataModel::REQUEST_PATH => '%uniqid%_request_path',
        UrlRewriteDataModel::TARGET_PATH => '%uniqid%_target_path',
        UrlRewriteDataModel::STORE_ID => 1,
        UrlRewriteDataModel::REDIRECT_TYPE => 0,
        UrlRewriteDataModel::DESCRIPTION => null,
        UrlRewriteDataModel::METADATA => null,
    ];
    /**
     * @var UrlRewriteFactory
     */
    private UrlRewriteFactory $urlRewriteFactory;

    /**
     * @var UrlRewriteResourceModel
     */
    private UrlRewriteResourceModel $urlRewriteResourceModel;

    /**
     * @var ProcessorInterface
     */
    private ProcessorInterface $dataProcessor;

    /**
     * @inheritDoc
     */
    public function __construct(
        UrlRewriteFactory $urlRewriteFactory,
        UrlRewriteResourceModel $urlRewriteResourceModel,
        ProcessorInterface $dataProcessor
    ) {
        $this->urlRewriteFactory = $urlRewriteFactory;
        $this->urlRewriteResourceModel = $urlRewriteResourceModel;
        $this->dataProcessor = $dataProcessor;
    }

    /**
     * @inheritDoc
     */
    public function apply(array $data = []): ?DataObject
    {
        $data = $this->dataProcessor->process($this, array_merge(self::DEFAULT_DATA, $data));
        $urlRewrite = $this->urlRewriteFactory->create();
        $urlRewrite->setData($data);
        $this->urlRewriteResourceModel->save($urlRewrite);
        return $urlRewrite;
    }

    /**
     * @inheritDoc
     */
    public function revert(DataObject $data): void
    {
        $urlRewrite = $this->urlRewriteFactory->create();
        $this->urlRewriteResourceModel->load($urlRewrite, $data->getId());
        if ($urlRewrite->getId()) {
            $this->urlRewriteResourceModel->delete($urlRewrite);
        }
    }
}
